    USE "fme-single-edits"

    GO
   -- Step 4. Create HTTP Webhook procedure
    --Note change "fme-single-edits" to the name of the database you wish to use

    CREATE PROCEDURE [dbo].[HTTP_DB_MESSAGE]( @sUrl varchar(2000), @message varchar(max))
    As
    Declare
    @obj int
    ,@hr int
    ,@status int
    ,@msg varchar(256)

    EXEC @hr = sp_OACreate 'MSXML2.ServerXMLHttp', @obj OUT
    if @hr <> 0 begin Raiserror('sp_OACreate MSXML2.ServerXMLHttp.3.0
    failed', 16,1) RETURN END

    EXEC @hr = sp_OAMethod @obj, 'open', NULL, 'POST', @sUrl, false
    if @hr <>0 BEGIN SET @msg = 'sp_OAMethod Open failed' GOTO eh END

    EXEC @hr = sp_OAMethod @obj, 'setRequestHeader', NULL, 'Content-Type',
    'application/json'
    if @hr <>0 BEGIN SET @msg = 'sp_OAMethod setRequestHeader failed' GOTO
    eh END

    EXEC @hr = sp_OAMethod @obj, sEND, NULL, @message
    if @hr <>0 BEGIN SET @msg = 'sp_OAMethod SEND failed' GOTO eh END

    EXEC @hr = sp_OADestroy @obj
    RETURN
    eh:
    EXEC @hr = sp_OADestroy @obj
    RETURN

    GO

    -- Step 5. Create dbo INSERT, UPDATE or DELETE Trigger on SINGLE_EXAMPLE table
    --Note change the @sURL value (after N') to your webhook URL. 

    CREATE TRIGGER [dbo].[TRG_SINGLE_EXAMPLE_ALL]
    ON [dbo].[SINGLE_EXAMPLE]
    AFTER  INSERT, UPDATE, DELETE
    AS
    BEGIN
        DECLARE @mes VARCHAR(max)
        DECLARE @hr INT
        DECLARE @obj INT
        -- SQL Server does not support 'for each rows' support.
        -- Therefore, it is necessary to make a loop and create a manual 'for each row' method
		IF EXISTS (SELECT 1 from inserted) AND NOT EXISTS (SELECT 1 FROM deleted)
			DECLARE curs CURSOR FOR
				 SELECT '{"operation":"INSERT","objectid":' + CAST(OBJECTID_1 as CHAR) + ',"geometry":"' + GEOM.STAsText() + '","username":"' + SYSTEM_USER + '"}' as mes
					FROM inserted
		ELSE IF EXISTS (SELECT 1 from deleted) AND NOT EXISTS (SELECT 1 FROM inserted) 
			DECLARE curs CURSOR FOR
				 SELECT '{"operation":"DELETE","objectid":' + CAST(OBJECTID_1 as CHAR) + ',"geometry":"' + GEOM.STAsText() + '","username":"' + SYSTEM_USER + '"}' as mes
					FROM deleted 
		ELSE IF EXISTS (SELECT 1 from inserted) AND EXISTS (SELECT 1 from deleted) 
			DECLARE curs CURSOR FOR
				 SELECT '{"operation":"UPDATE","objectid":' + CAST(OBJECTID_1 as CHAR) + ',"geometry":"' + GEOM.STAsText() + '","username":"' + SYSTEM_USER + '"}' as mes
					FROM inserted
		
        OPEN curs
        FETCH NEXT FROM curs INTO @mes
        WHILE @@FETCH_STATUS = 0
        BEGIN
            -- Run HTTP request procedure
            EXEC    [dbo].[HTTP_DB_MESSAGE]
			--Replace with your Webhook URL (after N').
            @sUrl = N'http://sm-sqledits.base.safe.com/fmerest/v3/automations/workflows/58c0c9ba-c107-45b7-b690-726b9bacee0d/846bfa13-d302-600f-8935-ee6af6772926/message?',
            @message = @mes   
          
            FETCH NEXT FROM curs INTO @mes
        END
        CLOSE curs
        DEALLOCATE curs
    END
